/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.compat.journeymap.DummyRailwayMarkerHandler;
import com.railwayteam.railways.compat.journeymap.TrainMarkerData;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.content.logistics.trains.entity.Train;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrainMarkerDataUpdatePacket
implements S2CPacket {
    private static final UUID NULL_ID = new UUID(0L, 0L);
    final UUID id;
    final TrainMarkerData data;

    public TrainMarkerDataUpdatePacket(Train train) {
        this.id = train.id;
        this.data = TrainMarkerData.make(train);
    }

    private static Optional<String> optionalString(String string) {
        return string == null || string.isEmpty() ? Optional.empty() : Optional.of(string);
    }

    public TrainMarkerDataUpdatePacket(FriendlyByteBuf buf) {
        this.id = buf.m_130259_();
        this.data = new TrainMarkerData(buf.m_130277_(), buf.readInt(), buf.m_130259_(), buf.m_130277_(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_()), buf.m_130135_(), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.m_130070_(this.data.name());
        buffer.writeInt(this.data.carriageCount());
        buffer.m_130077_(Optional.ofNullable(this.data.owner()).orElse(NULL_ID));
        buffer.m_130070_(this.data.destination());
        buffer.m_130085_(this.data.dimension().m_135782_());
        buffer.m_130064_(this.data.pos());
        buffer.writeBoolean(this.data.incomplete());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        if (!this.data.incomplete()) {
            DummyRailwayMarkerHandler.getInstance().registerData(this.id, this.data);
        }
    }
}

